/*
 * Decompiled with CFR 0.152.
 */
package o7410.bundlesbeyond;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_7157;
import net.minecraft.class_7485;
import net.minecraft.class_8015;
import o7410.bundlesbeyond.BundlesBeyondConfig;
import o7410.bundlesbeyond.BundlesBeyondConfigScreen;
import o7410.bundlesbeyond.ModEnabledState;
import o7410.bundlesbeyond.ScrollMode;

public class BundlesBeyondCommand {
    public static <T extends class_2172> void registerCommand(CommandDispatcher<T> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"bundlesbeyond").executes(BundlesBeyondCommand::configScreen)).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"mod_enabled_state").executes(BundlesBeyondCommand::executeGetModEnabledState)).then(RequiredArgumentBuilder.argument((String)"state", (ArgumentType)new class_7485<ModEnabledState>(ModEnabledState.CODEC, ModEnabledState::values){}).suggests(BundlesBeyondCommand::getModEnabledStateSuggestions).executes(BundlesBeyondCommand::executeSetModEnabledState)))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"scroll_mode").executes(BundlesBeyondCommand::executeGetScrollMode)).then(RequiredArgumentBuilder.argument((String)"mode", (ArgumentType)new class_7485<ScrollMode>(ScrollMode.CODEC, ScrollMode::values){}).suggests(BundlesBeyondCommand::getScrollModeSuggestions).executes(BundlesBeyondCommand::executeSetScrollMode)))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"slot_size").executes(BundlesBeyondCommand::executeGetSlotSize)).then(RequiredArgumentBuilder.argument((String)"size", (ArgumentType)IntegerArgumentType.integer((int)18)).suggests(BundlesBeyondCommand::getSlotSizeSuggestions).executes(BundlesBeyondCommand::executeSetSlotSize)))).then(LiteralArgumentBuilder.literal((String)"reloadconfig").executes(BundlesBeyondCommand::executeReloadConfig)));
    }

    private static void sendFeedback(CommandContext<? extends class_2172> context, class_2561 text) {
        class_2172 source = (class_2172)context.getSource();
        if (source instanceof FabricClientCommandSource) {
            FabricClientCommandSource fabricSource = (FabricClientCommandSource)source;
            fabricSource.sendFeedback(text);
        }
        if (source instanceof class_2168) {
            class_2168 serverSource = (class_2168)source;
            serverSource.method_9226(() -> text, false);
        }
    }

    private static void sendError(CommandContext<? extends class_2172> context, class_2561 text) {
        class_2172 source = (class_2172)context.getSource();
        if (source instanceof FabricClientCommandSource) {
            FabricClientCommandSource fabricSource = (FabricClientCommandSource)source;
            fabricSource.sendError(text);
        }
        if (source instanceof class_2168) {
            class_2168 serverSource = (class_2168)source;
            serverSource.method_9213(text);
        }
    }

    private static int configScreen(CommandContext<? extends class_2172> context) {
        class_310 client = class_310.method_1551();
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof class_408) {
            class_408 chatScreen = (class_408)class_4372;
            chatScreen.method_25415("", true);
        }
        client.method_48185(class_8015.field_41777);
        client.method_1507((class_437)new BundlesBeyondConfigScreen(null));
        return 0;
    }

    private static int executeGetModEnabledState(CommandContext<? extends class_2172> context) {
        ModEnabledState state = BundlesBeyondConfig.instance().modEnabledState;
        BundlesBeyondCommand.sendFeedback(context, (class_2561)class_2561.method_43470((String)"Bundles Beyond enabled state is currently: ").method_10852(state.getShortNameText()));
        return 0;
    }

    private static CompletableFuture<Suggestions> getModEnabledStateSuggestions(CommandContext<? extends class_2172> context, SuggestionsBuilder builder) {
        for (ModEnabledState state : ModEnabledState.values()) {
            builder.suggest(state.id, (Message)state.getDescriptionText());
        }
        return builder.buildFuture();
    }

    private static int executeSetModEnabledState(CommandContext<? extends class_2172> context) {
        ModEnabledState newModEnabledState = (ModEnabledState)((Object)context.getArgument("state", ModEnabledState.class));
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        BundlesBeyondCommand.sendFeedback(context, (class_2561)class_2561.method_43470((String)"Bundles Beyond enabled state is now: ").method_10852(newModEnabledState.getShortNameText()));
        if (config.modEnabledState != newModEnabledState) {
            config.modEnabledState = newModEnabledState;
            if (!BundlesBeyondConfig.save()) {
                BundlesBeyondCommand.sendError(context, (class_2561)class_2561.method_43470((String)"Failed to save Bundles Beyond config"));
            }
        }
        return 0;
    }

    private static int executeGetScrollMode(CommandContext<? extends class_2172> context) {
        BundlesBeyondCommand.sendFeedback(context, (class_2561)class_2561.method_43470((String)"Scroll mode is currently: ").method_10852(BundlesBeyondConfig.instance().scrollMode.getShortNameText()));
        return 0;
    }

    private static CompletableFuture<Suggestions> getScrollModeSuggestions(CommandContext<? extends class_2172> context, SuggestionsBuilder builder) {
        for (ScrollMode scrollMode : ScrollMode.values()) {
            builder.suggest(scrollMode.id, (Message)scrollMode.getDescriptionText());
        }
        return builder.buildFuture();
    }

    private static int executeSetScrollMode(CommandContext<? extends class_2172> context) {
        ScrollMode newMode = (ScrollMode)((Object)context.getArgument("mode", ScrollMode.class));
        BundlesBeyondCommand.sendFeedback(context, (class_2561)class_2561.method_43470((String)"Scroll mode is now: ").method_10852(newMode.getShortNameText()));
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        if (config.scrollMode != newMode) {
            config.scrollMode = newMode;
            if (!BundlesBeyondConfig.save()) {
                BundlesBeyondCommand.sendError(context, (class_2561)class_2561.method_43470((String)"Failed to save Bundles Beyond config"));
            }
        }
        return 0;
    }

    private static int executeGetSlotSize(CommandContext<? extends class_2172> context) {
        int slotSize;
        BundlesBeyondCommand.sendFeedback(context, (class_2561)class_2561.method_43470((String)("Slot size is currently: " + slotSize + ((slotSize = BundlesBeyondConfig.instance().slotSize) == 24 ? " (Vanilla)" : ""))));
        return 0;
    }

    private static CompletableFuture<Suggestions> getSlotSizeSuggestions(CommandContext<? extends class_2172> context, SuggestionsBuilder builder) {
        builder.suggest(24);
        return builder.buildFuture();
    }

    private static int executeSetSlotSize(CommandContext<? extends class_2172> context) {
        int slotSize;
        BundlesBeyondCommand.sendFeedback(context, (class_2561)class_2561.method_43470((String)("Slot size is now: " + slotSize + ((slotSize = IntegerArgumentType.getInteger(context, (String)"size")) == 24 ? " (Vanilla)" : ""))));
        BundlesBeyondConfig config = BundlesBeyondConfig.instance();
        if (config.slotSize != slotSize) {
            config.slotSize = slotSize;
            if (!BundlesBeyondConfig.save()) {
                BundlesBeyondCommand.sendError(context, (class_2561)class_2561.method_43470((String)"Failed to save Bundles Beyond config"));
            }
        }
        return 0;
    }

    private static int executeReloadConfig(CommandContext<? extends class_2172> context) {
        if (BundlesBeyondConfig.load()) {
            BundlesBeyondCommand.sendFeedback(context, (class_2561)class_2561.method_43470((String)"Reloaded Bundles Beyond config"));
        } else {
            BundlesBeyondCommand.sendError(context, (class_2561)class_2561.method_43470((String)"Failed to reload Bundles Beyond config"));
        }
        return 0;
    }
}

